

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;


// vars

float2		foliage_distances;
float2		foliage_sectionPosition;
float3		foliage_eyePosition;

////////////////////////////////////////////////////////////

struct VS_INPUT 
{
	float4 basePosition		: POSITION;
	float3 normal			: NORMAL;
	float4 colour			: COLOR;

	float2 uv				: TEXCOORD0;
	float2 sizePos			: TEXCOORD1;
};
	
	
struct VS_OUTPUT 
{
	float4	position		: POSITION;
	float4	colour			: COLOR0;

	float2	uv1				: TEXCOORD0;
	float	alpha			: TEXCOORD1;
};

////////////////////////////////////////////////////////////

VS_OUTPUT vs_foliage_imposter( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;

	float4 nBasePosition = input.basePosition;
	nBasePosition.xz += foliage_sectionPosition;

	float3 nTangent = normalize(cross( input.normal, normalize(foliage_eyePosition - nBasePosition ) ));

	float3 nOutPos = nBasePosition.xyz + input.sizePos.x * nTangent + input.sizePos.y * input.normal;
	
	output.position = mul(float4(nOutPos,1), shader_transform_viewProj);

	output.colour = input.colour;

	output.uv1 = input.uv;
	
	output.alpha = saturate((foliage_distances.x - output.position.z) / (foliage_distances.x - foliage_distances.y));

	return output;
}


////////////////////////////////////////////////////////////

sampler sampler_colour_1 = sampler_state
{
	Texture = (shader_texture_0);
	AddressU = Clamp; 
	AddressV = Clamp; 
};

////////////////////////////////////////////////////////////

float4 ps_foliage_imposter( VS_OUTPUT input ) : COLOR0
{
	return float4(tex2D(sampler_colour_1, input.uv1).rgb * input.colour.rgb * input.colour.a, tex2D(sampler_colour_1, input.uv1).a * input.alpha);
}

////////////////////////////////////////////////////////////

technique foliage_imposter_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_foliage_imposter();	
		PixelShader = compile ps_2_0 ps_foliage_imposter();	
	}
}

technique foliage_imposter_11_00
{
	pass P0
	{
	}
}